#include <bits/stdc++.h>
using namespace std;

struct Vektor
{
    double ugao;
    double x;
    double y;
    int indeks;   
};

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    const double PI = acos(-1.0);

    vector<Vektor> vektori(n);

    for(int i = 0; i < n; i++){
        double x, y;
        cin >> x >> y;

        double ugao = atan2(y, x);   
        if(ugao < 0.0){
            ugao += 2.0 * PI;      
        }

        vektori[i].ugao   = ugao;
        vektori[i].x      = x;
        vektori[i].y      = y;
        vektori[i].indeks = i;      
    }

    sort(vektori.begin(), vektori.end(), [](const Vektor &a, const Vektor &b){
        return a.ugao < b.ugao;
    });

    //dupliramo da bi bilo lakse
    vector<Vektor> prosireni(2 * n);
    for(int i = 0; i < n; i++){
        prosireni[i] = vektori[i];        
        prosireni[i + n] = vektori[i];     
        prosireni[i + n].ugao += 2.0 * PI; 
    }

    double najboljaDuzina2 = 0.0;
    int najboljiLevi = 0, najboljiDesni = 0;

    double zbirX = 0.0, zbirY = 0.0;
    int desni = 0;

    //prvi prolaz
    for(int levi = 0; levi < n; levi++){
        while(desni < levi + n and prosireni[desni].ugao - prosireni[levi].ugao < PI) {
            zbirX += prosireni[desni].x;
            zbirY += prosireni[desni].y;
            desni++;
        }

        double osnovnaDuzina2 = zbirX * zbirX + zbirY * zbirY;

        //probamo da izbacimo sa pocetka
        double najboljaLevo = osnovnaDuzina2;
        int leviNajboljiLevo = levi;
        {
            double trenutniX = zbirX;
            double trenutniY = zbirY;
            int leviTrenutni = levi;
            
            while(leviTrenutni < desni){
                trenutniX -= prosireni[leviTrenutni].x;
                trenutniY -= prosireni[leviTrenutni].y;
                
                leviTrenutni++;
                double duzina2 = trenutniX * trenutniX + trenutniY * trenutniY;
                
                if(duzina2 > najboljaLevo){
                    najboljaLevo = duzina2;
                    leviNajboljiLevo = leviTrenutni;
                } 
                else{
                    break;
                }
            }
        }

        //probamo da izbacimo sa kraja
        double najboljaDesno = osnovnaDuzina2;
        int desniNajboljiDesno = desni;
        {
            double trenutniX = zbirX;
            double trenutniY = zbirY;
            int desniTrenutni = desni - 1;
            
            while(desniTrenutni >= levi){
                trenutniX -= prosireni[desniTrenutni].x;
                trenutniY -= prosireni[desniTrenutni].y;
                
                desniTrenutni--;
                double duzina2 = trenutniX * trenutniX + trenutniY * trenutniY;
                
                if(duzina2 > najboljaDesno){
                    najboljaDesno = duzina2;
                    desniNajboljiDesno = desniTrenutni + 1;
                } 
                else {
                    break;
                }
            }
        }

        if(osnovnaDuzina2 >= najboljaLevo and osnovnaDuzina2 >= najboljaDesno){
            if(osnovnaDuzina2 > najboljaDuzina2){
                najboljaDuzina2 = osnovnaDuzina2;
                najboljiLevi = levi;
                najboljiDesni = desni;
            }
        }
        else if(najboljaLevo >= osnovnaDuzina2 and najboljaLevo >= najboljaDesno){
            if(najboljaLevo > najboljaDuzina2){
                najboljaDuzina2 = najboljaLevo;
                najboljiLevi = leviNajboljiLevo;
                najboljiDesni = desni;
            }
        }
        else{
            if(najboljaDesno > najboljaDuzina2){
                najboljaDuzina2 = najboljaDesno;
                najboljiLevi = levi;
                najboljiDesni = desniNajboljiDesno;
            }
        }

        zbirX -= prosireni[levi].x;
        zbirY -= prosireni[levi].y;
    }

    zbirX = 0.0;
    zbirY = 0.0;
    desni = 2 * n - 1;

    // drugi prolaz - suprotan smer
    for(int levi = 2*n - 1; levi >= n; levi--){
        while(desni > levi - n and prosireni[levi].ugao - prosireni[desni].ugao < PI){
            zbirX += prosireni[desni].x;
            zbirY += prosireni[desni].y;
            desni--;
        }

        int levi0 = desni + 1;
        int desni0 = levi + 1;
        double osnovnaDuzina2 = zbirX * zbirX + zbirY * zbirY;

        double najboljaLevo = osnovnaDuzina2;
        int leviNajboljiLevo = levi0;
        {
            double trenutniX = zbirX;
            double trenutniY = zbirY;
            
            int leviTrenutni = levi0;
            
            while(leviTrenutni < desni0){
                trenutniX -= prosireni[leviTrenutni].x;
                trenutniY -= prosireni[leviTrenutni].y;
                
                leviTrenutni++;
                double duzina2 = trenutniX * trenutniX + trenutniY * trenutniY;
                
                if(duzina2 > najboljaLevo){
                    najboljaLevo = duzina2;
                    leviNajboljiLevo = leviTrenutni;
                } 
                else{
                    break;
                }
            }
        }

        double najboljaDesno = osnovnaDuzina2;
        int desniNajboljiDesno = desni0;
        {
            double trenutniX = zbirX;
            double trenutniY = zbirY;
            int desniTrenutni = desni0 - 1;
            
            while(desniTrenutni >= levi0){
                trenutniX -= prosireni[desniTrenutni].x;
                trenutniY -= prosireni[desniTrenutni].y;
                
                desniTrenutni--;
                double duzina2 = trenutniX * trenutniX + trenutniY * trenutniY;
                
                if(duzina2 > najboljaDesno){
                    najboljaDesno = duzina2;
                    desniNajboljiDesno = desniTrenutni + 1;
                } 
                else{
                    break;
                }
            }
        }

        if(osnovnaDuzina2 >= najboljaLevo and osnovnaDuzina2 >= najboljaDesno){
            if(osnovnaDuzina2 > najboljaDuzina2){
                najboljaDuzina2 = osnovnaDuzina2;
                najboljiLevi = levi0;
                najboljiDesni = desni0;
            }
        }
        else if(najboljaLevo >= osnovnaDuzina2 and najboljaLevo >= najboljaDesno){
            if(najboljaLevo > najboljaDuzina2){
                najboljaDuzina2 = najboljaLevo;
                najboljiLevi = leviNajboljiLevo;
                najboljiDesni = desni0;
            }
        }
        else{
            if(najboljaDesno > najboljaDuzina2){
                najboljaDuzina2 = najboljaDesno;
                najboljiLevi = levi0;
                najboljiDesni = desniNajboljiDesno;
            }
        }

        zbirX -= prosireni[levi].x;
        zbirY -= prosireni[levi].y;
    }

    vector<int> izabrani;
    for(int k = najboljiLevi; k < najboljiDesni; k++){
        izabrani.push_back(prosireni[k].indeks);
    }
    
    sort(izabrani.begin(), izabrani.end());
    
    cout << izabrani.size() << '\n';
    
    for(int i = 0; i < izabrani.size(); i++){
        cout << izabrani[i] + 1 << ' ';     //indeks krece od 1
    }
    return 0;
}